clc; clear; 

%% Problem Data
n = 2;

Q = [0.3   -0.7
    -0.7    2.0];

h  = [-1; .1];

x0 = [-1; 1];

 
% computing the feasible set
n_poly = 5;
A = zeros(n_poly,2);
b = zeros(n_poly,1);

theta_poly = (0:(2*pi)/n_poly:2*pi);
x_poly = cos(theta_poly);
y_poly = 1.5*sin(theta_poly-pi/10);

for i = 1:n_poly

    p = [x_poly(i+1)-x_poly(i)
         y_poly(i+1)-y_poly(i)];

    a = [p(2),-p(1)];
    a = a/norm(a);

    A(i,:) = a;

    b(i) = a*[x_poly(i); y_poly(i)];

end



%% Algorithm

options = optimoptions('quadprog','Algorithm','active-set','OptimalityTolerance',1e-8,'Display','off');
[x_qp,f_qp] = quadprog(Q,h,A,b,[],[],[],[],x0,options);

% Projected grad descent
[x_pgd,data,k] = Projected_Grad_Desc(@(x)(objective(x,Q,h)),Q,h,A,b,x0);

% Unbounded solution projected on X
options = optimoptions('quadprog','OptimalityTolerance',1e-8,'Display','off');
x_unb = quadprog(Q,h,[],[],[],[],[],[],x0,options);
x_unb_proj = pg(x_unb,A,b);

fprintf('Solution\n  Constrained Unconstr Projected\n')
disp([x_qp,x_unb_proj])
fprintf('Function value\n')
disp([0.5*x_qp'*Q*x_qp + h'*x_qp, 0.5*x_unb_proj'*Q*x_unb_proj + h'*x_unb_proj])

% fprintf('Solution\n  QuadProg     PGD\n')
% disp([x_qp,x_pgd])
% fprintf('Function value\n')
% disp([0.5*x_qp'*Q*x_qp + h'*x_qp, 0.5*x_pgd'*Q*x_pgd + h'*x_pgd])

%% Plotting

% Plot the QP
figure(1),clf, hold on, box on
axis equal
plotregion(-A,-b,[],[],[0.8,0.8,0.8]); % plot the feasible region
obj = @(x,y) 0.5*[x;y]'*Q*[x;y] + h'*[x;y];
fcontour(obj,'--','LineWidth',2,'LevelList',linspace(-1.5,2,10))
colorbar

% Plot optimum

plot(x_qp(1),x_qp(2),"hexagram",'MarkerSize',15,'MarkerFaceColor','b')
pause(1)

% Plot projected unconstrained optimum

plot(x_unb_proj(1),x_unb_proj(2),"hexagram",'MarkerSize',10,'MarkerFaceColor','y')
pause(1)
quiver(x_unb(1),x_unb(2),x_unb_proj(1)-x_unb(1),x_unb_proj(2)-x_unb(2),0,'Color','k','LineWidth',2)

% Plot the iterates and search directions

for i= 1:k
    plot(data.x(1,i),data.x(2,i),'ko','MarkerFaceColor','k')
    plot(data.x(1,i)-data.g(1,i),data.x(2,i)-data.g(2,i),'ro','MarkerFaceColor','G')
    quiver(data.x(1,i),data.x(2,i),+data.d(1,i),+data.d(2,i),0,'Color','red','LineWidth',1)
    quiver(data.x(1,i),data.x(2,i),-data.g(1,i),-data.g(2,i),0,'Color','green','LineWidth',1)
    pause(0.1)
end


function x = pg(y,A,b) %projection function

n = length(y);
H = eye(n);
x0 = y;
options = optimset('Display','off');
x = quadprog(H,-y,A,b,[],[],[],[],x0,options);

end






